/*
 * Neighbour.java
 *
 * 
 */
 package DisCSP.DistributedCSP;

import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class Neighbour
{
	
	//le variabili di cui il vicino  responsabile e che interessano l'agente
	private String[] vars;
	private InetAddress addr;
	private int port;
	private int receivedFrom=0;
	private int sentTo=0;
	

 	/** Costruttore di Neighbour
     * 
     * @param v le variabili di cui il vicino  responsabile
     * @param a l'IP del vicino
     * @param p la porta del vicino
     * 
     */	
	public Neighbour(String[] v, String a, int p) throws UnknownHostException
	{
		vars= new String[v.length];
		for(int i=0;i<vars.length;i++)
		{
			vars[i]=v[i];
		}
		addr=InetAddress.getByName(a);
		port=p;
	}

 	/** Costruttore di Neighbour
     * 
     * @param v le variabili di cui il vicino  responsabile
     * @param a l'IP del vicino
     * @param p la porta del vicino
     * 
     */	
	
	public Neighbour(String[] v, InetAddress a, int p)
	{
		for(int i=0;i<vars.length;i++)
		{
			vars[i]=v[i];
		}
		
		addr=a;
		port=p;
		
	}
	
	/** Restituisce il numero di variabili di cui  responsabile il vicino
     * 
     * @return il numero di variabili di cui  responsabile il vicino
     * 
     */	
	public int relatedVariables()
	{
		return vars.length;
	}
	
	/** Restituisce il nome dell'i-esima variabile di cui  responsabile il vicino
     * 
	 * @param i l'indice
     * @return il nome dell'i-esima variabile di cui  responsabile il vicino
     * 
     */	

	public String variableAt(int i)
	{
		return vars[i];
	}
	
	/** Restituisce l'indirizzo IP del vicino
     * 
     * @return l'indirizzo IP del vicino
     * 
     */		
	public InetAddress address()
	{
		return addr;
	}
	
	/** Restituisce l'indirizzo IP del vicino come stringa
     * 
     * @return una stringa rappresentante l'indirizzo IP del vicino
     * 
     */		
	
	public String addressString()
	{
		return addr.getHostAddress();
	}
	
	/** Restituisce la porta del vicino
     * 
     * @return l'intero corrispondente alla porta del vicino
     * 
     */		

	public int port()
	{
		return port;
	}
	
	/** Restituisce il numero di messaggi ricevuti dal vicino
     * 
     * @return il numero di messaggi ricevuti dal vicino
     * 
     */		

	public int receivedFrom()
	{
		return receivedFrom;
	}
	
	/** Restituisce il numero di messaggi inviati al vicino
     * 
     * @return il numero di messaggi inviati al vicino
     * 
     */		

	public int sentTo()
	{
		return sentTo;
	}
	
	/** Incrementa il numero di messaggi ricevuti dal vicino
     * 
     * 
     */		

	public void incrReceivedFrom()
	{
		receivedFrom++;
	}
	
	/** Incrementa il numero di messaggi inviati al vicino
     * 
     * 
     */		

	public void incrSentTo()
	{
		sentTo++;
	}
	
	/** Verifica se il vicino  responsabile di una certa variabile
     * 
	 * @param v il nome della variabile
     * @return true se il vicino  responsabile della variabile, false altrimenti
     * 
     */		

	public boolean isResponsable(String v)
	{
		for(int i=0;i<vars.length;i++)
		{
			if (vars[i].equals(v)) return true;
		}
		
		return false;
	}
	
	/** Stampa le variabili di cui il vicino  responsabile 
     * 
     * @return una stringa contenente i nomi delle variabili di cui il vicino  responsabile 
     * 
     */		
	
	public String printVars()
	{
		String ris="";
		int len=vars.length;
		for(int i=0;i<len;i++)
		{
			if(i!=(len-1)) ris+=vars[i]+",";
			else ris+=vars[i];
		}
		
		return ris;
	}
}
